---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：152-Cat インデックス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **全カラム数が100以上の主張**：正確なカラム数を数え上げていない

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.indices.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestIndicesAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行153
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行191

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは GET /_cat/indices と GET /_cat/indices/{index} | E-01, E-02 行117 | ○ |
| C-02 | リクエストパラメータにformat, bytes, local等が存在 | E-01 params | ○ |
| C-03 | healthパラメータでgreen/yellow/redフィルタ可能 | E-02 行930-943 | ○ |
| C-04 | expand_wildcardsのデフォルトはall | E-01 expand_wildcards.default | ○ |
| C-05 | 4つの内部リクエストを発行（GetSettings, ClusterState, IndicesStats, ClusterHealth） | E-02 行166-237 | ○ |
| C-06 | GroupedActionListenerで4レスポンスを集約 | E-02 行346-395 | ○ |
| C-07 | master_timeoutは非推奨でcluster_manager_timeoutを使用 | E-01, E-02 行104-107, 148-154 | ○ |
| C-08 | ResponseLimitSettingsによるインデックス数制限 | E-02 行109, 258-265 | ○ |
| C-09 | AbstractListActionを継承 | E-02 行100 | ○ |
| C-10 | GetSettingsで認可済みインデックスを解決 | E-02 行267-291 コメント | ○ |
| C-11 | healthパラメータがnullでないとき、ヘルスフィルタリングが適用 | E-02 行930-943 | ○ |
| C-12 | クローズ済みインデックスのstatsはnull扱い | E-02 行948-955 | ○ |
| C-13 | 関連機能No.105 インデックス統計 | E-04 | ○ |
| C-14 | isActionPaginatedはfalseを返す | E-02 行1238-1240 | ○ |
| C-15 | 全カラム数は100以上 | **根拠なし**（推定） | △ |

## 4) 不足情報（Unknown / Missing）
- カラム数の正確な数え上げを行っていない。getTableWithHeader()のaddCell呼び出し回数を正確にカウントする必要がある
  - 候補：ソースコードの行415-889を精査

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なAPI仕様・パラメータ・処理フローはソースコードから直接確認済み
- 1: 中リスク - 表示カラムの一部を抜粋しているため、完全な一覧ではない

## 6) レビュアーチェックリスト（最小）
- [ ] 表示カラムの一覧がソースコードのgetTableWithHeader()と一致しているか
- [ ] リクエストパラメータがcat.indices.jsonの定義と一致しているか
- [ ] 4つの内部リクエストの処理フローが正確か
- [ ] ResponseLimitの閾値設定が正しく記述されているか
